<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sunny-Side Gym Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<link rel="icon" href="includes/logo.png" type="image/png">

    <style>
    
        body {
            margin: 0;
            padding: 0;
        }
        .scan-btn {
    position: fixed;
    bottom: 20px;
    right: 20px;
    width: 70px;
    height: 70px;
    z-index: 1050;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}
span#memberAction {
    color: #ffff !important;
}
        .sidebar {
            width: 240px;
            background: #fac13a;
            color: #fff;
            height: 100%;
            position: fixed;
            top: 0;
            left: 0;
            transform: translateX(0);
            transition: transform 0.3s ease;
            z-index: 999;
        }
        .sidebar .logo {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid #495057;
        }
        .sidebar .logo img {
            max-width: 80%;
            height: auto;
        }
        .sidebar a {
    color: #2d0c3c;
    text-decoration: none;
    padding: 12px 20px;
    display: block;
}
        .sidebar a:hover {
            background: #495057;
        }
        .main {
            margin-left: 240px;
        }

        /* MOBILE STYLES */
        @media (max-width: 768px) {
            .mobile-topbar {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 60px;
                background: #fac13a;
                padding: 10px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                z-index: 1000;
            }
            .mobile-topbar img {
                height: 40px;
            }
            .sidebar {
                width: 100%;
                background: #fac13a;
                transform: translateX(-100%);
                position: fixed;
                height: 100%;
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .sidebar-header {
                background: #fac13a;
                padding: 10px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                border-bottom: 1px solid #ffd44a;
            }
            .sidebar-header img {
                height: 40px;
            }
            .sidebar a {
                color: #000;
            }
            .sidebar a:hover {
                background: #ffd44a;
            }
            .main {
                margin-left: 0;
                margin-top: 60px;
            }
            body.sidebar-open .mobile-topbar {
                display: none;
            }
        }

        @media (min-width: 769px) {
            #toggleSidebar {
                display: none;
            }
        }
    </style>
</head>
<body>

<!-- Mobile Top Bar -->
<div class="d-md-none mobile-topbar" id="mobileTopbar">
    <img src="includes/logo.png" alt="Logo">
    <button id="toggleSidebar" class="btn btn-dark btn-sm"><i class="fas fa-bars"></i></button>
</div>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <!-- Sidebar header for mobile (yellow bar inside sidebar) -->
    <div class="sidebar-header d-md-none">
        <img src="includes/logo.png" alt="Logo">
        <button id="closeSidebar" class="btn btn-dark btn-sm"><i class="fas fa-times"></i></button>
    </div>

    <!-- Desktop logo inside sidebar -->
    <div class="logo d-none d-md-block">
        <img src="includes/logo.png" alt="Logo">
    </div>

    <!-- Menu Links -->
  <!-- Menu Links -->
<!-- Menu Links -->
<a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
<hr>
<a href="add_member.php"><i class="fas fa-user-plus"></i> Add New Member</a>
<hr>
<a href="members_all.php"><i class="fas fa-users"></i> All Members</a>
<a href="members_active.php"><i class="fas fa-user-check"></i> Active Members</a>
<a href="members_expired.php"><i class="fas fa-user-times"></i> Expired Members</a>
<a href="members_expiring.php"><i class="fas fa-user-clock"></i> Expiring Soon</a>
<a href="members_families.php"><i class="fas fa-people-roof"></i> Family Groups</a>
<a href="banned_members.php"><i class="fas fa-ban"></i> Banned Members</a>
<a href="warnings.php"><i class="fas fa-exclamation-triangle"></i> Warnings</a>
<a href="attendance.php"><i class="fas fa-calendar-check"></i> Attendance</a>
<hr>
<a href="logout.php" onclick="return confirm('Are you sure you want to logout?');"><i class="fas fa-sign-out-alt"></i> Logout</a>


</div>

<!-- Main Content -->
<div class="main p-3">
